<?php

require 'db.php';
session_start();

if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit();
}


if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['update_data'])) {
    $id = $_POST['id'];
    $min_amount = $_POST['min_amount'];
    $max_amount = $_POST['max_amount'];
    $upi = $_POST['upi'];

    
    $update_sql = "UPDATE data SET min_amount = ?, max_amount = ?, upi = ? WHERE id = ?";
    $stmt = $conn->prepare($update_sql);
    $stmt->bind_param("ddsi", $min_amount, $max_amount, $upi, $id);

    if ($stmt->execute()) {
        $message = "Data updated successfully!";
    } else {
        $message = "Failed to update data: " . $conn->error;
    }
    $stmt->close();
}


if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['update_user'])) {
    $username = $_POST['username'];
    $new_password = $_POST['new_password'];

    
    $update_user_sql = "UPDATE users SET username = ?, password = ? WHERE username = ?";
    $stmt_user = $conn->prepare($update_user_sql);
    $stmt_user->bind_param("sss", $username, $new_password, $_SESSION['username']);

    if ($stmt_user->execute()) {
        $_SESSION['username'] = $username; 
        $user_message = "User updated successfully!";
    } else {
        $user_message = "Failed to update user: " . $conn->error;
    }
    $stmt_user->close();
}



$sql = "SELECT * FROM data";
$result = $conn->query($sql);


$user_sql = "SELECT username FROM users WHERE username = ?";
$stmt_user_details = $conn->prepare($user_sql);
$stmt_user_details->bind_param("s", $_SESSION['username']);
$stmt_user_details->execute();
$user_details = $stmt_user_details->get_result()->fetch_assoc();
$stmt_user_details->close();

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Data</title>
    <style>
        
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background-color: #f4f4f4;
        }

        .container {
            max-width: 600px;
            margin: 0 auto;
            background: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        h1 {
            text-align: center;
            color: #333;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th, td {
            padding: 10px;
            border: 1px solid #ddd;
            text-align: left;
        }

        th {
            background-color: #f0f0f0;
        }

        form {
            margin-top: 20px;
        }

        .form-group {
            margin-bottom: 15px;
        }

        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }

        input[type="text"], input[type="number"], input[type="password"] {
            width: 100%;
            padding: 8px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }

        button {
            padding: 10px 20px;
            background-color: #28a745;
            color: #fff;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }

        button:hover {
            background-color: #218838;
        }

        .logout-button {
            display: inline-block;
            margin-top: 20px;
            padding: 10px 20px;
            background-color: #ea4c4c;
            color: #fff;
            text-decoration: none;
            border-radius: 5px;
            font-size: 16px;
        }

        .logout-button:hover {
            background-color: #d43b3b;
        }

        .message {
            margin: 10px 0;
            padding: 10px;
            background-color: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
            border-radius: 5px;
        }

        .error {
            background-color: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Welcome, <?php echo htmlspecialchars($_SESSION['username']); ?>!</h1>

        
        <?php if (isset($message)): ?>
            <div class="message"><?php echo $message; ?></div>
        <?php endif; ?>
        
        <?php if (isset($user_message)): ?>
            <div class="message"><?php echo $user_message; ?></div>
        <?php endif; ?>
        
        <h2>Update User Details</h2>
        <form method="POST" action="">
            <div class="form-group">
                <label for="username">Username</label>
                <input type="text" name="username" value="<?php echo htmlspecialchars($user_details['username']); ?>" required>
            </div>
            <div class="form-group">
                <label for="new_password">New Password</label>
                <input type="password" name="new_password" required>
            </div>
            <button type="submit" name="update_user">Update User</button>
        </form>

        <h2>Manage Data</h2>
        <?php if ($result->num_rows > 0): ?>
            <table>
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Min Amount</th>
                        <th>Max Amount</th>
                        <th>UPI</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = $result->fetch_assoc()): ?>
                        <tr>
                            <form method="POST" action="">
                                <td>
                                    <?php echo $row['id']; ?>
                                    <input type="hidden" name="id" value="<?php echo $row['id']; ?>">
                                </td>
                                <td>
                                    <input type="number" name="min_amount" value="<?php echo $row['min_amount']; ?>" required>
                                </td>
                                <td>
                                    <input type="number" name="max_amount" value="<?php echo $row['max_amount']; ?>" required>
                                </td>
                                <td>
                                    <input type="text" name="upi" value="<?php echo $row['upi']; ?>" required>
                                </td>
                                <td>
                                    <button type="submit" name="update_data">Update</button>
                                </td>
                            </form>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        <?php else: ?>
            <p>No data available.</p>
        <?php endif; ?>

        <a href="logout.php" class="logout-button">Logout</a>
    </div>
</body>
</html>

<?php
$conn->close();
?>
